// #############################################################################

function yData=dpLagrange_Solver(y0,t0,tD,odeType)

    // Lagrangesches Differentialgleichungssystem
    function ydot=fdpLagrange(t,y)
        w1=y(1); w2=y(2);
        p1=y(3); p2=y(4);
        wd=fwdot(w1,w2,p1,p2);
        pd=fpdot(w1,w2,p1,p2);
        ydot=wd(1)*[1;0;0;0] ..
            +wd(2)*[0;1;0;0] ..
            +pd(1)*[0;0;1;0] ..
            +pd(2)*[0;0;0;1];
    endfunction;
    
    // Lösung der Differntialgleichungen
    fdp=fdpLagrange;
    if odeType == "" then
        yData=ode(y0,t0,tData,fdp);
    else
        yData=ode(odeType,y0,t0,tData,fdp);
    end;
endfunction;

// #############################################################################
disp('Geladen: dpLagrange-DGLSystem.sci');

