// #############################################################################
// Berechnung des Gesamtdrehimpulses

gmL=2.0*gmt;

// Funktion für den gesamten Drehimpuls
function rdrehimp=fdrehimp(w1,w2,w1d,w2d)
    rdrehimp=gmL*(w1d+mue*lbd^2*w2d+mue*lbd*(w1d+w2d)*cos(w1-w2));
endfunction;

// Funktion für den Hamilton-Drehimpuls 1
function rdrehimpH1=fdrehimpH1(w1,w2,w1d,w2d)
    rdrehimpH1=gmL*(w1d+mue*lbd*w2d*cos(w1-w2));
endfunction;

// Funktion für den Hamilton-Drehimpuls 2
function rdrehimpH2=fdrehimpH2(w1,w2,w1d,w2d)
    rdrehimpH2=gmL*(mue*lbd^2*w2d+mue*lbd*w1d*cos(w1-w2));
endfunction;

// #############################################################################

function rdrehimpdata=fdrehimpdata(ydata)
    for i=1:size(ydata,"c")
        w1=ydata(1,i);
        w2=ydata(2,i);
        p1=ydata(3,i);
        p2=ydata(4,i);
        rdrehimpdata(i)=fdrehimp(w1,w2,p1,p2);
    end
endfunction;

function rdrehimpH1data=fdrehimpH1data(ydata)
    for i=1:size(ydata,"c")
        w1=ydata(1,i);
        w2=ydata(2,i);
        p1=ydata(3,i);
        p2=ydata(4,i);
        rdrehimpH1data(i)=fdrehimpH1(w1,w2,p1,p2);
    end
endfunction;

function rdrehimpH2data=fdrehimpH2data(ydata)
    for i=1:size(ydata,"c")
        w1=ydata(1,i);
        w2=ydata(2,i);
        p1=ydata(3,i);
        p2=ydata(4,i);
        rdrehimpH2data(i)=fdrehimpH2(w1,w2,p1,p2);
    end
endfunction;

// #############################################################################
disp('Geladen: dpLagrange-DrehimpulsAlgorithmen.sci');