// ############################################################################
// Ausgabe der Daten

function fdpLagrange_DrehimpulsAusgaben(tData,yData,odeType)

    drehimpdata=fdrehimpdata(yData);

    drehimpH1data=fdrehimpH1data(yData);

    drehimpH2data=fdrehimpH2data(yData);

    // ########################################################################

    drehimp_0=drehimpdata(1); // Gesamtenergie, Konstante der Bewegung
    px_drehimp=[tBegin;tEnd];

    // ########################################################################

    function fDisplayNull()
        null=0;
        px_null=[tBegin;tEnd];
        py_null=[null;null];
        e=xpoly(px_null,py_null);
        e.foreground=color('grey');
    end;

    function fDisplayLine(yw)
        px_null=[tBegin;tEnd];
        py_null=[yw;yw];
        e=xpoly(px_null,py_null);
        e.thickness=2;
        e.line_style=8;
        e.foreground=color('maroon');
    endfunction;

    // ########################################################################

    if %T then 
        my_handle1=scf(1);
        clf(my_handle1,"reset");

        a=gca();
        a.x_label.text = "Zeit [s]";
        a.y_label.text = "Drehimpuls [N m s]";

        xgrid(color("lightgrey"));
        tDP='> DP => || '+string(w1_0g)+' | '+string(w1dot_0g) ..
                  +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                  +' || '+string(gc) ..
                  +' || '+fng(odeType) ..
                  +' ||';
        xtitle(['Doppelpendel - Drehimpulsverhalten über die Zeit';tDP]);

        plot(tData,drehimpdata,'red');

        py_drehimp=[drehimp_0;drehimp_0];
        e=xpoly(px_drehimp,py_drehimp);
        e.foreground=color('scilabmagenta3');

        legend(['Drehimpuls(t)','Drehimpuls(0)'],"lower_caption",%f);
    end;

    // ########################################################################

    if %T then 
        my_handle1=scf(2);
        clf(my_handle1,"reset");

        a=gca();
        a.x_label.text = "Zeit [s]";
        a.y_label.text = "Drehimpuls [N m s]";

        xgrid(color("lightgrey"));
        tDP='> DP => || '+string(w1_0g)+' | '+string(w1dot_0g) ..
                  +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                  +' || '+string(gc) ..
                  +' || '+fng(odeType) ..
                  +' ||';
        xtitle(['Doppelpendel - Drehimpulsverhalten über die Zeit';tDP]);

        plot(tData,drehimpdata,'red');
        plot(tData,drehimpH1data,'green');
        plot(tData,drehimpH2data,'blue');

        py_drehimp=[drehimp_0;drehimp_0];
        e=xpoly(px_drehimp,py_drehimp);
        e.foreground=color('scilabmagenta3');

        legend(['Drehimpuls(t)','Drehimpuls1(t)','Drehimpuls2(t)','Drehimpuls(0)'],"lower_caption",%f);
    end;

endfunction;

// #############################################################################

disp('Geladen: dpLagrange-DrehimpulsAusgaben.sci');