// #############################################################################
// Berechnung der Energien aus den Anfangsbedingungen über kartesische 
// Koordinaten - als Vergleichswerte genutzt.

// Kinetische Energie
function rekin_kart=fekin_kart(w1,w2,w1d,w2d)
    x1d=l1*cos(w1)*w1d;
    y1d=l1*sin(w1)*w1d;
    v1q=x1d^2+y1d^2;
    x2d=x1d+l2*cos(w2)*w2d;
    y2d=y1d+l2*sin(w2)*w2d;
    v2q=x2d^2+y2d^2;
    rekin_kart=0.5*(m1*v1q+m2*v2q);
endfunction;

// Potentielle Energie
function repot_kart=fepot_kart(w1,w2)
    y1=-l1*cos(w1);
    y2=y1-l2*cos(w2);
    repot_kart=m1*gc*y1+m2*gc*y2;
endfunction;

// Totale Energie
function retot_kart=fetot_kart(w1,w2,w1d,w2d)
    retot_kart=fekin_kart(w1,w2,w1d,w2d)+fepot_kart(w1,w2);
endfunction;

// #############################################################################
// Berechnung der Energien aus den Winkelkkoordinaten

// Funktion für die kinetische Energie
function rekin=fekin(w1,w2,w1d,w2d)
    rekin=gmt*(w1d^2+mue*lbd^2*w2d^2+2.0*mue*lbd*w1d*w2d*cos(w1-w2));
endfunction;

// Funktion für die potentielle Energie
function repot=fepot(w1,w2)
    repot=gmv*(cos(w1)+mue*lbd*cos(w2));
endfunction;

// Funktion für die totale Energie
function retot=fetot(w1,w2,w1d,w2d)
    retot=fekin(w1,w2,w1d,w2d)+fepot(w1,w2);
endfunction;

// #############################################################################

function rekindata=fekindata(ydata)
    for i=1:size(ydata,"c")
        w1=ydata(1,i);
        w2=ydata(2,i);
        p1=ydata(3,i);
        p2=ydata(4,i);
        rekindata(i)=fekin(w1,w2,p1,p2);
    end
endfunction;

function repotdata=fepotdata(ydata)
    for i=1:size(ydata,"c")
        w1=ydata(1,i);
        w2=ydata(2,i);
        repotdata(i)=fepot(w1,w2);
    end
endfunction;

function retot=fetot(w1,w2,p1,p2)
    retot=fekin(w1,w2,p1,p2)+fepot(w1,w2)
endfunction

function retotdata=fetotdata(ydata)
    for i=1:size(ydata,"c")
        w1=ydata(1,i);
        w2=ydata(2,i);
        p1=ydata(3,i);
        p2=ydata(4,i);
        retotdata(i)=fetot(w1,w2,p1,p2);
    end
endfunction;

// #############################################################################
disp('Geladen: dpLagrange-EnergieAlgorithmen.sci');