// ############################################################################
// Ausgabe der Daten

// ############################################################################

function fdpLagrange_EnergieAusgaben(tData,yData,odeType)

    etotdata=fetotdata(yData);
    ekindata=fekindata(yData);
    epotdata=fepotdata(yData);

    etot0=etotdata(1); // Gesamtenergie, Konstante der Bewegung
    px_etot=[tBegin;tEnd];

    delta_etot=etotdata-etot0;
    delta_etot0=delta_etot(1);

    // ########################################################################

    function fDisplayNull()
        null=0;
        px_null=[tBegin;tEnd];
        py_null=[null;null];
        e=xpoly(px_null,py_null);
        e.foreground=color('grey');
    end;

    function fDisplayLine(yw)
        px_null=[tBegin;tEnd];
        py_null=[yw;yw];
        e=xpoly(px_null,py_null);
        e.thickness=2;
        e.line_style=8;
        e.foreground=color('maroon');
    endfunction;

    // ########################################################################

    if %T then 
        my_handle1=scf(1);
        clf(my_handle1,"reset");

        a=gca();
        a.x_label.text = "Zeit [s]";
        a.y_label.text = "Energien [Joule]";

        xgrid(color("lightgrey"));
        tDP='> DP => || '+string(w1_0g)+' | '+string(w1dot_0g) ..
                  +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                  +' || '+string(gc) ..
                  +' || '+fng(odeType) ..
                  +' ||';
        xtitle(['Doppelpendel - Energieverhalten über die Zeit';tDP]);

        plot(tData,etotdata,'red');
        plot(tData,ekindata,'blue');
        plot(tData,epotdata,'green');

        // py_etot=[etot0;etot0];
        // e=xpoly(px_etot,py_etot);
        // e.foreground=color('scilabmagenta3');

        legend(['Etot(t)';'Ekin(t)';'Epot(t)'],"lower_caption",%f);
    end;

    // #########################################################################

    if %T then 
        my_handle2=scf(2);
        clf(my_handle2,"reset");
        a=gca();

        a.x_label.text = "Zeit [s]";
        a.y_label.text = "Abweichungen vom physikalischen Wert Etot(0)  [Joule]";

        xgrid(color("lightgrey"));
        tDP='> DP => || '+string(w1_0g)+' | '+string(w1dot_0g) ..
                  +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                  +' || '+string(gc) ..
                  +' || '+fng(odeType) ..
                  +' ||';
        xtitle(['Doppelpendel - Energieverhalten über die Zeit';tDP]);

        fDisplayNull();
        plot(tData,delta_etot,'red');

        legend(['Etot (t) - Etot(0)'],"lower_caption",%f);
    end;

    // #########################################################################

    if %F then 
        mean_etot=mean(etotdata);
        mean_ekin=mean(ekindata);
        mean_epot=mean(epotdata);

        max_etot=max(etotdata);
        max_ekin=max(ekindata);
        max_epot=max(epotdata);

        min_etot=min(etotdata);
        min_ekin=min(ekindata);
        min_epot=min(epotdata);

        init_etot=etotdata(1);
        init_ekin=ekindata(1);
        init_epot=epotdata(1);
        
        // Zur Kontrolle der Algorithmen
        kart_ekin=fekin_kart(w1_0,w2_0,w1dot_0,w2dot_0);
        kart_epot=fepot_kart(w1_0,w2_0);
        kart_etot=fetot_kart(w1_0,w2_0,w1dot_0,w2dot_0);

        max_Detot=max(delta_etot);
        mean_Detot=mean(delta_etot);
        min_Detot=min(delta_etot);

        mprintf('   \n');
        mprintf('---\n');
        mprintf('kart_ekin    : %g\n', kart_ekin);
        mprintf('init_ekin    : %g\n', init_ekin);
        mprintf('max_ekindata : %g\n', max_ekin);
        mprintf('mean_ekindata: %g\n', mean_ekin);
        mprintf('min_ekindata : %g\n', min_ekin);
        mprintf('---\n');
        mprintf('kart_epot    : %g\n', kart_epot);
        mprintf('init_epot    : %g\n', init_epot);
        mprintf('max_epotdata : %g\n', max_epot);
        mprintf('mean_epotdata: %g\n', mean_epot);
        mprintf('min_epotdata : %g\n', min_epot);
        mprintf('---\n');
        mprintf('kart_etot    : %g\n', kart_etot);
        mprintf('init_etot    : %g\n', init_etot);
        mprintf('max_etotdata : %g\n', max_etot);
        mprintf('mean_etotdata: %g\n', mean_etot);
        mprintf('min_etotdata : %g\n', min_etot);
        mprintf('---\n');
        mprintf('max_Detot    : %g\n', max_Detot);
        mprintf('mean_Detot   : %g\n', mean_Detot);
        mprintf('min_Detot    : %g\n', min_Detot);
        mprintf('---\n');
    end;

    // #########################################################################

    if %T then
        function rw180data=fw180data(yL)
            rw180data=[];
            lg=size(yL,"c");
            for i=1:lg
                w=yL(1,i);
                vp=[cos(w);sin(w)];
                w=atand(vp(2),vp(1));
                rw180data(i)=w;
            end;
        endfunction;

        w1data=fw180data(yData(1,:));
        w2data=fw180data(yData(2,:));
        max_w1data=max(w1data);
        max_w2data=max(w2data);
        is_big_wdata=(max_w1data > 175.0)| (max_w2data > 175.0);

        my_handle3=scf(3);
        clf(my_handle3,"reset");
        a=gca();
        a.x_label.text = "Zeit [s]";
        a.y_label.text = "Pendelwinkel  [°]";
    
        xgrid(color("lightgrey"));
        tDP='> DP => || '+string(w1_0g)+' | '+string(w1dot_0g) ..
                  +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                  +' || '+string(gc) ..
                  +' || '+fng(odeType) ..
                  +' ||';
        xtitle(['Doppelpendel - Pendelwinkel über die Zeit';tDP]);
        plot(tData,w1data,'red');
        plot(tData,w2data,'green');

        legend(["$\theta_1\ (t)$";"$\theta_2\ (t)$"],"lower_caption",%f);
        fDisplayNull();
        if is_big_wdata then
            fDisplayLine(180);
            fDisplayLine(-180);
        end;
    end;

endfunction;

// #############################################################################
disp('Geladen: dpLagrange-EnergieAusgaben.sci');