// #############################################################################
// Simulieren der Orts-Daten

// #############################################################################
// Zeichnerische Ausgabe der Ortsdaten der beiden Pendelmassen

function fdpLagrange_Simulation(yData)

    posdata=fposdata(yData);
    nbpionts=size(posdata,"c");
    
    xmax=(l1+l2)*1.05;
    xmin=(-1)*xmax;
    ymax=xmax;
    ymin=xmin;
    
    whiteid=color("white");
    
    my_handle = scf(100001);
    clf(my_handle,"reset");
    
    drawlater;
    
    // Achsen zeichnen
    plot2d(0,0,-1,rect=[xmin,ymin,xmax,ymax],frameflag=7);
    drawnow();
    
    // Nur keine Hektik
    sleep(3000);
    realtimeinit(stepTime);
    realtime(0);
    
    // Schrittweise Ausgabe der Simulation
    for i=1:nbpionts
        drawlater;
    
        if i>1 then
            // Gezeichnete Kreuze und Stangen der letzten Ausgabe 
            // werden in weiß überschrieben.
    
            plot2d(posdata(1,i-1),posdata(2,i-1),-1,rect=[xmin,ymin,xmax,ymax],frameflag=7)
            p = get("hdl");
            p.children.mark_mode = "on";
            p.children.mark_foreground = whiteid;
    
            plot2d(posdata(3,i-1),posdata(4,i-1),-1,rect=[xmin,ymin,xmax,ymax],frameflag=7)
            p = get("hdl");
            p.children.mark_mode = "on";
            p.children.mark_foreground = whiteid;
    
            px=[0;posdata(1,i-1)];
            py=[0;posdata(2,i-1)];
            e=xpoly(px,py);
            e.foreground=whiteid;
    
            px=[posdata(1,i-1);posdata(3,i-1)];
            py=[posdata(2,i-1);posdata(4,i-1)];
            e=xpoly(px,py);
            e.foreground=whiteid;
        end;
    
        // Zeichnet das untere Kreuz der oberen Stange das mittlere Kreuz), in schwarz
        plot2d(posdata(1,i),posdata(2,i),-1,rect=[xmin,ymin,xmax,ymax],frameflag=7);
        
        // Zeichnet das untere Kreuz der unteren Stange, in schwarz
        plot2d(posdata(3,i),posdata(4,i),-1,rect=[xmin,ymin,xmax,ymax],frameflag=7);
    
        // Zeichnet die obere Stange
        px=[0;posdata(1,i)];
        py=[0;posdata(2,i)];
        xpoly(px,py);
    
        // Zeichnet die untere Stange
        px=[posdata(1,i);posdata(3,i)];
        py=[posdata(2,i);posdata(4,i)];
        xpoly(px,py);
    
        // Zeichnet das fixe obere Kreuz der oberen Stange, in schwarz
        plot2d(0,0,-1,rect=[xmin,ymin,xmax,ymax],frameflag=7);
    
        // Warten bis zum nächsten Zyklus
        realtime(i);
        drawnow();
    end;

endfunction;

// #############################################################################
disp('Geladen: dpLagrange-OrtsSimulation.sci');